# Advanced Text Highlighter Chrome Extension

A powerful Chrome extension for highlighting text on web pages with multiple profiles and advanced features.

## Features

- Enable/disable highlighting with a single click
- Add highlight words through text input or button click
- Support for multiple highlight profiles (default, work, study, etc.)
- Import highlights from text files, Word documents, and Excel spreadsheets
- Edit or delete individual highlight words
- Different highlight colors for different profiles
- Persistent storage of highlights across browser sessions
- Dynamic content support (highlights new content as it loads)
- Support for special characters and symbols in highlight words

## Installation

1. Clone or download this repository
2. Open Chrome and go to `chrome://extensions/`
3. Enable "Developer mode" in the top right corner
4. Click "Load unpacked" and select the extension directory

## Usage

1. Click the extension icon in Chrome to open the popup interface
2. Use the toggle switch to enable/disable highlighting
3. Enter words or phrases to highlight in the input field
4. Press Enter or click the "Add" button to add highlights
5. Import highlights from files using the import section
6. Switch between different profiles using the dropdown menu
7. Create new profiles with the "New Profile" button
8. Edit or delete highlights using the buttons next to each word

## Profiles

- Default: Yellow highlights
- Work: Green highlights
- Study: Blue highlights
- Custom: Create your own profiles with custom names

## File Import Support

- Text files (.txt)
- Word documents (.doc, .docx)
- Excel spreadsheets (.xls, .xlsx)

## Notes

- Highlights are synchronized across devices when signed into Chrome
- The extension ignores text in scripts, styles, and form inputs
- Special characters are properly escaped for accurate highlighting
- Dynamic content is automatically highlighted as it loads

## Contributing

Feel free to submit issues and enhancement requests!

## Changelog

### V1.0.0 (2025-03-08)

1. 插件第一个版本支持添加、导入、删除、修改高亮词
2. 支持高亮词颜色修改
3. 支持清除全部高亮词
4. 支持自动高亮词
5. 支持区分大小写（需要刷新页面生效：待修复）
6. 支持全局匹配功能
7. 支持多选和全选高亮词进行删除操作 