var compile = function(functionObject) {
    return function (scope) {
        return functionObject.toString().match(/\/\*([\s\S]*?)\*\//)[1].replace(/\$\{\w.+\}/g, function (variable) {
            var value = scope;
            variable = variable.replace('${', '').replace('}', '');
            variable.split('.').forEach(function (section) {
                value = value[section];
            });
            return value;
        });
    }
};

let isDragging = false;

// 检测页面是否包含音视频元素
function hasMediaContent() {
    const hasVideo = document.getElementsByTagName('video').length > 0;
    const hasAudio = document.getElementsByTagName('audio').length > 0;
    // 检查是否存在嵌入的视频
    const hasIframe = Array.from(document.getElementsByTagName('iframe')).some(iframe => {
        try {
            return iframe.contentWindow.document.getElementsByTagName('video').length > 0 ||
                   iframe.contentWindow.document.getElementsByTagName('audio').length > 0;
        } catch (e) {
            return false;
        }
    });

    return hasVideo || hasAudio || hasIframe;
}

function observeMediaElements() {
    const observer = new MutationObserver((mutations) => {
        if (hasMediaContent()) {
            showFloatBall();
            observer.disconnect();
        }
    });

    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
}

function showFloatBall() {
    chrome.storage.local.get(['openBall'], function(result) {
        console.log("rtvt openBall: ", result.openBall);

        if (result.openBall === undefined || result.openBall == "1") {
        
            const floatballopenStr = chrome.i18n.getMessage("floatballopen");

            const containerHtml = compile(function() {/*
                <div id="rtvt-autoinsert-div">
                    <div class="closeButton">
                        <div class="closeButton-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="24" height="24.000001907348633" viewBox="0 0 24 24.000001907348633"><defs><clipPath id="master_svg0_1295_43494"><rect x="0" y="0" width="24" height="24.000001907348633" rx="0"/></clipPath></defs><g clip-path="url(#master_svg0_1295_43494)"><g><path d="M12,1.5C6.21074,1.5,1.5,6.21001,1.5,12C1.5,17.79,6.21001,22.5,12,22.5C17.7893,22.5,22.5,17.79,22.5,12C22.5,6.21001,17.79,1.5,12,1.5ZM16.2833,15.234C16.5758,15.528,16.575,16.002000000000002,16.2818,16.2945C16.1355,16.439999999999998,15.9443,16.5135,15.7523,16.5135C15.5595,16.5135,15.3675,16.439999999999998,15.2213,16.293L11.9963,13.0582L8.760760000000001,16.2593C8.61453,16.4033,8.42399,16.476,8.23349,16.476C8.040009999999999,16.476,7.84725,16.401699999999998,7.70025,16.2533C7.40925,15.9585,7.4115,15.4845,7.70626,15.1928L10.93801,11.9963L7.71824,8.766C7.42574,8.47273,7.4265,7.998,7.71973,7.7055C8.013,7.41223,8.48696,7.41376,8.78023,7.70699L12.0045,10.94099L15.24,7.74001C15.534,7.44827,16.0095,7.45126,16.3005,7.74602C16.5922,8.04077,16.589199999999998,8.515509999999999,16.2945,8.806519999999999L13.0628,12.003L16.2833,15.234Z" fill="#DFDFDF" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></g></svg>
                        </div>
                    </div>
                    <div class="autoinsert-inner-view">
                        <div class="logo-view">
                            <span class="logo-svg"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="21" height="18" viewBox="0 0 21 18"><defs><linearGradient x1="0.5" y1="-0.11139648407697678" x2="0.5" y2="1" id="master_svg0_1347_87479"><stop offset="0%" stop-color="#F6C4FF" stop-opacity="1"/><stop offset="100%" stop-color="#8B33FF" stop-opacity="1"/><stop offset="100%" stop-color="#000000" stop-opacity="0"/></linearGradient><linearGradient x1="0.5" y1="-0.11139648407697678" x2="0.5" y2="1" id="master_svg1_1347_87479"><stop offset="0%" stop-color="#F6C4FF" stop-opacity="1"/><stop offset="100%" stop-color="#8B33FF" stop-opacity="1"/><stop offset="100%" stop-color="#000000" stop-opacity="0"/></linearGradient></defs><g><g><path d="M0,0C0,0,5.85,0,5.85,0C5.85,0,13,18,13,18C13,18,7.15,18,7.15,18C7.15,18,0,0,0,0Z" fill="url(#master_svg0_1347_87479)" fill-opacity="1"/></g><g><path d="M15.150090599060059,0L21.00009059906006,0L19.550690599060058,3.64893L13.700660599060058,3.64893L15.150090599060059,0ZM12.734350599060058,6.08157L8.000090599060059,18L13.850090599060058,18L18.584390599060058,6.08157L12.734350599060058,6.08157Z" fill-rule="evenodd" fill="url(#master_svg1_1347_87479)" fill-opacity="1"/></g></g></svg></span>

                            <div class="wave-view">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="13.239130973815918" height="11.428571701049805" viewBox="0 0 13.239130973815918 11.428571701049805"><defs><clipPath id="master_svg0_1347_88300"><rect x="0" y="0" width="13.239130973815918" height="11.428571701049805" rx="0"/></clipPath></defs><g clip-path="url(#master_svg0_1347_88300)"><g><path d="M5.979585748214722,8.913016078796387C6.1748957482147215,8.913016078796387,6.320345748214722,8.780296078796386,6.320345748214722,8.618866078796387C6.320345748214722,8.618866078796387,6.320345748214722,2.5310900787963866,6.320345748214722,2.5310900787963866C6.320345748214722,2.3660710787963866,6.170745748214722,2.2369260787963867,5.979585748214722,2.2369260787963867C5.788425748214722,2.2369260787963867,5.638825748214721,2.3660710787963866,5.638825748214721,2.5310900787963866C5.638825748214721,2.5310900787963866,5.638825748214721,8.618866078796387,5.638825748214721,8.618866078796387C5.638825748214721,8.780296078796386,5.788425748214722,8.913016078796387,5.979585748214722,8.913016078796387C5.979585748214722,8.913016078796387,5.979585748214722,8.913016078796387,5.979585748214722,8.913016078796387ZM8.535345748214722,8.199136078796386C8.730655748214723,8.199136078796386,8.876105748214723,8.069996078796386,8.876105748214723,7.904966078796387C8.876105748214723,7.904966078796387,8.876105748214723,3.2449760787963866,8.876105748214723,3.2449760787963866C8.876105748214723,3.0799580787963867,8.726505748214722,2.9508140787963866,8.535345748214722,2.9508140787963866C8.34003574821472,2.9508140787963866,8.19458574821472,3.0799580787963867,8.19458574821472,3.2449760787963866C8.19458574821472,3.2449760787963866,8.19458574821472,7.904966078796387,8.19458574821472,7.904966078796387C8.19458574821472,8.069996078796386,8.34003574821472,8.199136078796386,8.535345748214722,8.199136078796386C8.535345748214722,8.199136078796386,8.535345748214722,8.199136078796386,8.535345748214722,8.199136078796386ZM4.699635748214722,7.686146078796387C4.894945748214722,7.686146078796387,5.044555748214721,7.557006078796387,5.044555748214721,7.391976078796387C5.044555748214721,7.391976078796387,5.044555748214721,3.7579760787963865,5.044555748214721,3.7579760787963865C5.044555748214721,3.592956078796387,4.894945748214722,3.4638060787963867,4.699635748214722,3.4638060787963867C4.5084657482147215,3.4638060787963867,4.363015748214721,3.592956078796387,4.363015748214721,3.7579760787963865C4.363015748214721,3.7579760787963865,4.363015748214721,7.391976078796387,4.363015748214721,7.391976078796387C4.363015748214721,7.557006078796387,4.5084657482147215,7.686146078796387,4.699635748214722,7.686146078796387C4.699635748214722,7.686146078796387,4.699635748214722,7.686146078796387,4.699635748214722,7.686146078796387ZM7.259535748214722,7.234126078796387C7.450695748214722,7.234126078796387,7.596145748214722,7.101406078796387,7.596145748214722,6.939976078796387C7.596145748214722,6.939976078796387,7.596145748214722,4.2099760787963865,7.596145748214722,4.2099760787963865C7.596145748214722,4.044966078796387,7.450695748214722,3.9158160787963867,7.259535748214722,3.9158160787963867C7.064225748214722,3.9158160787963867,6.918775748214722,4.048546078796386,6.918775748214722,4.2099760787963865C6.918775748214722,4.2099760787963865,6.918775748214722,6.939976078796387,6.918775748214722,6.939976078796387C6.918775748214722,7.101406078796387,7.064225748214722,7.234126078796387,7.259535748214722,7.234126078796387C7.259535748214722,7.234126078796387,7.259535748214722,7.234126078796387,7.259535748214722,7.234126078796387ZM9.811145748214722,6.624276078796386C10.006455748214723,6.624276078796386,10.151905748214721,6.495136078796387,10.151905748214721,6.330126078796387C10.151905748214721,6.330126078796387,10.151905748214721,4.819836078796387,10.151905748214721,4.819836078796387C10.151905748214721,4.654816078796387,10.006455748214723,4.525666078796387,9.811145748214722,4.525666078796387C9.615815748214722,4.525666078796387,9.470365748214721,4.654816078796387,9.470365748214721,4.819836078796387C9.470365748214721,4.819836078796387,9.470365748214721,6.330126078796387,9.470365748214721,6.330126078796387C9.470365748214721,6.495136078796387,9.619985748214722,6.624276078796386,9.811145748214722,6.624276078796386C9.811145748214722,6.624276078796386,9.811145748214722,6.624276078796386,9.811145748214722,6.624276078796386ZM3.4238317482147216,6.3408860787963865C3.6191517482147217,6.3408860787963865,3.764600748214722,6.211726078796387,3.764600748214722,6.046716078796386C3.764600748214722,6.046716078796386,3.764600748214722,5.103226078796387,3.764600748214722,5.103226078796387C3.764600748214722,4.9382260787963865,3.6149957482147217,4.805476078796387,3.4238317482147216,4.805476078796387C3.228514748214722,4.805476078796387,3.0830657482147217,4.9382260787963865,3.0830657482147217,5.103226078796387C3.0830657482147217,5.103226078796387,3.0830657482147217,6.046716078796386,3.0830657482147217,6.046716078796386C3.0830657482147217,6.211726078796387,3.228514748214722,6.3408860787963865,3.4238317482147216,6.3408860787963865C3.4238317482147216,6.3408860787963865,3.4238317482147216,6.3408860787963865,3.4238317482147216,6.3408860787963865Z" fill="#DABEFF" fill-opacity="1"/></g></g></svg>
                            </div>

                        </div>
            
                        <span class="start-rtvt-ext">${floatballopenStr}</span>
                    </div>
                </div>
            */});

            if ($('#rtvt-autoinsert-div').length == 0) {
                $("body").append(containerHtml({floatballopenStr}));
            
                $("#rtvt-autoinsert-div").draggable({
                    axis: "y",
                    containment: "window"
                }, {
                    start: function() {
                        isDragging = true;
                    },
                    stop: function() {
                        $("#rtvt-autoinsert-div").css('left', 'inherit');
                        setTimeout(() => {
                            isDragging = false;
                        }, 0);
                    }
                });
            }

            const floatballcloseStr = chrome.i18n.getMessage("floatballclose");
            const floatballclosenextStr = chrome.i18n.getMessage("floatballclosenext");
            const floatballcloseforeverStr = chrome.i18n.getMessage("floatballcloseforever");
            const floatballclosedescStr = chrome.i18n.getMessage("floatballclosedesc");
            const sureStr = chrome.i18n.getMessage("sure");
            const cancelStr = chrome.i18n.getMessage("cancel");
            const containerCloseDivHtml = compile(function() {/*
                <div id="rtvt-close-ball">
                    <p class="closeBallTitle">${floatballcloseStr}</p>

                    <div class="closeBallOption">
                        <label>
                            <input type="radio" name="choice" value="option1"> ${floatballclosenextStr}
                        </label>
                        <label>
                            <input type="radio" name="choice" value="option2"> ${floatballcloseforeverStr}
                        </label>
                    </div>

                    <div class="closeBallDesc">${floatballclosedescStr}</div>

                    <div class="closeBallButtonView">
                        <button class="closeBallBtn cancelBallBtn">${cancelStr}</button>
                        <button class="closeBallBtn sureBallBtn">${sureStr}</button>
                    </div>
                </div>
            */});

            if ($('#rtvt-close-ball').length == 0) {
                $("body").append(containerCloseDivHtml({floatballcloseStr, floatballclosenextStr, floatballcloseforeverStr, floatballclosedescStr, sureStr, cancelStr}));

                $('.cancelBallBtn').on('click', function() {
                    $('#rtvt-close-ball').hide();
                });

                $('.sureBallBtn').on('click', function() {
                    const selectedValue = $('input[name="choice"]:checked').val();

                    if (selectedValue === undefined) {
                        return;
                    }

                    if (selectedValue == 'option1') {
                        $('#rtvt-autoinsert-div').hide();
                        $('#rtvt-close-ball').hide();
                        return;
                    } else if (selectedValue == 'option2') {
                        chrome.storage.local.set({openBall: "0"}, function() {
                            $('#rtvt-autoinsert-div').hide();
                            $('#rtvt-close-ball').hide();
                        });
                    }
                });

            }
        
            $('#rtvt-autoinsert-div').on('click', function() {
                if (isDragging) {
                    event.preventDefault();
                    return false;
                }
                chrome.runtime.sendMessage({ action: "open_popup" });
            });
            
            $('.closeButton-inner').on('click', function() {
                $('#rtvt-close-ball').show();
                event.preventDefault();
                return false;
            });
            
        }
    });
}

function init() {
    if (hasMediaContent()) {
        showFloatBall();
    } else {
        observeMediaElements();
    }
}

if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
} else {
    init();
}
