loadStatus = false;

// Load localized text
function loadLocalizedText() {
    const startedStatusText = chrome.i18n.getMessage("started_status");
    const startedStatusElement = document.getElementById("started-status");
    if (startedStatusElement && startedStatusText) {
        startedStatusElement.textContent = startedStatusText;
    }
}

// Initialize localized text when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    loadLocalizedText();
});

// Get the current id
chrome.tabs.query(
  {
      active: true,
      currentWindow: true,
  },
  (tabs) => {
      const tabId = tabs[0].id;
      // Get the streamId
      chrome.tabCapture.getMediaStreamId(
          {
              consumerTabId: tabId,
          },
          (streamId) => {

              if (!loadStatus) {
                loadStatus = true;
                // Load the content.js

                chrome.scripting.executeScript(
                  {
                      target: { tabId },
                      files: ["thirdParty/jquery-3.7.1.min.js", "thirdParty/jquery-ui.min.js", "thirdParty/crypto-js.min.js", "thirdParty/modernizr.custom.js", "thirdParty/dlmenu.min.js", "thirdParty/int64.min.js", "thirdParty/msgpack.min.js", "thirdParty/fpnn.min.js", "thirdParty/rtvt.sdk.js", "content.js"],
                  },
                  () => {
                      // Send the streamId to the tab
                      chrome.tabs.sendMessage(tabId, {contentStart: true, streamId: streamId, tabId: tabId});
                  }
                );
              }
          }
      );
  }
);
