importScripts('thirdParty/rtvt.sdk.js');
importScripts("thirdParty/fpnn.min.js");
importScripts("thirdParty/msgpack.min.js");
importScripts("thirdParty/int64.min.js");


let tabWorkData = {};

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.workerStart) {
    startAudioCapture(request.tabId);

  } else if (request.pcmToWorker) {

    try {
      chrome.tabs.sendMessage(request.tabId, { pcmData: request.data });
    } catch (e) {
      chrome.runtime.sendMessage({
        closeTab: request.tabId,
      });
    }

  } else if (request.workerResume) {
    resumeAudioCapture(request.tabId);
  }
  else if (request.cmd == "start") {
    let tabId = request.tabId;
    if (tabWorkData[tabId] === undefined) {
      tabWorkData[tabId] = {
        globalSeg: 0,
        rtvtClient: null,
        rtvtStream: null,
      };
    }
    createRtvt(request.data);
  }
  else if (request.cmd == "stop") {
    let tabId = request.tabId;
    if (tabWorkData[tabId] != null && tabWorkData[tabId].rtvtClient !== null) {
      tabWorkData[tabId].globalSeg = 0;
      tabWorkData[tabId].rtvtClient.destory();
      tabWorkData[tabId].rtvtClient = null;
      delete tabWorkData[tabId];
      console.log("stop rtvt tab: " + tabId);
    }
  }
  else if (request.cmd == "sendVoice") {
    let tabId = request.tabId;
    if (tabWorkData[tabId] != null && tabWorkData[tabId].rtvtClient !== null) {
      const pcmData = (new Int16Array(request.pcmData)).buffer;
      tabWorkData[tabId].rtvtClient.sendVoice(tabWorkData[tabId].rtvtStream, tabWorkData[tabId].globalSeg++, pcmData);
    }
  }

  return true;
});


function uploadLog(tabId, event_id, log) {
  chrome.tabs.sendMessage(tabId, {
    cmd: "log", data: {
      "event_id": event_id,
      "log": log
    }
  });
}

function createRtvt(data) {
  tabWorkData[data.tabId].rtvtClient = new RTVTClient({
    endpoint: data.endpoint,
    pid: data.pid,
    uid: data.globalConfig.uid,
  });

  tabWorkData[data.tabId].rtvtClient.on("ReloginCompleted", function (ok, errorCode) {
    console.log("ReloginCompleted, ok: " + ok + " errorCode: " + errorCode);
  });

  tabWorkData[data.tabId].rtvtClient.on("ErrorRecorder", function (error) {
    console.log(error);
    chrome.tabs.sendMessage(data.tabId, { cmd: "ErrorRecorder", errorCode: error.code, tabId: data.tabId });
  });

  tabWorkData[data.tabId].rtvtClient.login(data.token, data.ts, async function (ok, errorCode) {
    console.log("login: ", ok, " errorCode: ", errorCode);
    //console.log(errorCode);
    let tabId = data.tabId;
    let log = "rtvtClient login result: " + ok + " errorCode: " + errorCode;
    uploadLog(data.tabId, "login", log);

    chrome.tabs.sendMessage(tabId, { cmd: "loginResult", data: { ok: ok, errorCode: errorCode } });

    if (!ok) {
      console.log("login fail: " + errorCode);
      // TODO
      return;
    }

    needAlt = true;
    if (data.globalConfig.altLang == 'none')
      needAlt = false;

    var globalConfig = data.globalConfig;

    console.log("createstream tabId: ", tabId, tabWorkData);
    tabWorkData[data.tabId].rtvtClient.createStream(globalConfig.uid, globalConfig.asrLang, globalConfig.altLang, true, true, needAlt, async function (stream, errorCode) {
      if (stream == null) {
        chrome.tabs.sendMessage(tabId, { cmd: "log", data: log });
        uploadLog(data.tabId, "create_stream", "create stream fail: " + errorCode);
        // TODO
        return;
      }

      uploadLog(data.tabId, "create_stream", "create stream id: " + stream._streamID.toString());

      chrome.tabs.sendMessage(tabId, { cmd: "createStream", data: { id: stream._streamID.toString() } });

      tabWorkData[data.tabId].rtvtStream = stream;

      tabWorkData[data.tabId].rtvtClient.on("recognizedResult", function (data) {
        data.streamId = data.streamId.toString();
        data.taskId = data.taskId.toString();
        chrome.tabs.sendMessage(tabId, { cmd: "recognizedResult", data: data });
      });

      tabWorkData[data.tabId].rtvtClient.on("recognizedTempResult", function (data) {
        chrome.tabs.sendMessage(tabId, { cmd: "recognizedTempResult", data: data });
      });

      tabWorkData[data.tabId].rtvtClient.on("translatedResult", function (data) {
        data.streamId = data.streamId.toString();
        data.taskId = data.taskId.toString();
        chrome.tabs.sendMessage(tabId, { cmd: "translatedResult", data: data });
      });

      tabWorkData[data.tabId].rtvtClient.on("translatedTempResult", function (data) {
        chrome.tabs.sendMessage(tabId, { cmd: "translatedTempResult", data: data });
      });
    });
  });
}


chrome.runtime.onMessageExternal.addListener((message, sender, sendResponse) => {
  console.log("chrome.runtime.message", message);
  chrome.tabs.query({}, function (tabs) {
    tabs.forEach(function (tab) {
      console.log(tab.id, tab.url);
      chrome.tabs.sendMessage(tab.id, {
        loginStatus: true,
        data: message
      });
    });
  });
  chrome.cookies.set({
    url: "https://ilivedata.com",
    name: "chrome_ex_uid",
    value: message.data.uid,
    domain: "ilivedata.com",
    path: "/",
    expirationDate: Math.floor(Date.now() / 1000) + 315360000
  }, function (cookie) {
    if (chrome.runtime.lastError) {
      console.error("Error setting cookie:", chrome.runtime.lastError);
    } else {
      console.log("Permanent Cookie set successfully:", cookie);
    }
  });

  chrome.cookies.set({
    url: "https://ilivedata.com",
    name: "chrome_ex_token",
    value: message.data.token,
    domain: "ilivedata.com",
    path: "/",
    expirationDate: Math.floor(Date.now() / 1000) + 604800  // 7 days
  }, function (cookie) {
    if (chrome.runtime.lastError) {
      console.error("Error setting cookie:", chrome.runtime.lastError);
    } else {
      console.log("Permanent Cookie set successfully:", cookie);
    }
  });
});

chrome.tabs.onRemoved.addListener(function (tabId, removeInfo) {
  console.log("close tab: ");
  console.log(tabId);

  chrome.runtime.sendMessage({
    closeTab: tabId,
  });

  if (tabWorkData[tabId] != null && tabWorkData[tabId].rtvtClient !== null) {
    tabWorkData[tabId].globalSeg = 0;
    tabWorkData[tabId].rtvtClient.destory();
    tabWorkData[tabId].rtvtClient = null;
    delete tabWorkData[tabId];
  }
});

/*
var startAudioCapture = async function(tabId) {
  try {
      const existingContexts = await chrome.runtime.getContexts({});
      let recording = false;

      const offscreenDocument = existingContexts.find(
        (c) => c.contextType === 'OFFSCREEN_DOCUMENT'
      );

      // If an offscreen document is not already open, create one.
      if (!offscreenDocument) {
        // Create an offscreen document.
        await chrome.offscreen.createDocument({
          url: 'offscreen.html',
          reasons: ['USER_MEDIA'],
          justification: 'Recording from chrome.tabCapture API'
        });
      } else {
        recording = offscreenDocument.documentUrl.endsWith('#recording');
      }

      if (recording) {
        chrome.runtime.sendMessage({
          type: 'stop-recording',
          target: 'offscreen',
          tabId: tabId
        });
        return;
      }

      // Get a MediaStream for the active tab.
      const streamId = await chrome.tabCapture.getMediaStreamId({
        targetTabId: tabId
      });

      try {

        // Send the stream ID to the offscreen document to start recording.
        chrome.runtime.sendMessage({
          type: 'start-recording',
          target: 'offscreen',
          data: streamId,
          tabId: tabId
        });

        chrome.tabs.sendMessage(tabId, {changePermission: true});

      } catch (e) {
        chrome.runtime.sendMessage({
          closeTab: tabId,
        });
      }
  } catch (ex) {
    console.log("send noPermission message");
    chrome.tabs.sendMessage(tabId, {noPermission: true, ex: ex.message});
  }
};
*/

var startAudioCapture = async function (tabId) {
  try {
    // 首先检查该标签页是否已经在捕获
    const capturedTabs = await chrome.tabCapture.getCapturedTabs();
    const isTabCaptured = capturedTabs.some(tab => tab.tabId === tabId);

    if (isTabCaptured) {
      console.log('Tab is already being captured:', tabId);
      return;
    }

    // 首先尝试创建离屏文档
    try {
      await chrome.offscreen.createDocument({
        url: 'offscreen.html',
        reasons: ['USER_MEDIA'],
        justification: 'Recording from chrome.tabCapture API'
      });
    } catch (err) {
      // 如果文档已存在，会抛出错误，这是正常的
      console.log('Offscreen document may already exist:', err);
      if (!err.message.includes('Only a single offscreen document may be created')) {
        chrome.tabs.sendMessage(tabId, { logs: true, ex: err.message });
      }
    }

    // Get a MediaStream for the active tab
    const streamId = await chrome.tabCapture.getMediaStreamId({
      targetTabId: tabId
    });

    try {
      // Send the stream ID to the offscreen document to start recording
      chrome.runtime.sendMessage({
        type: 'start-recording',
        target: 'offscreen',
        data: streamId,
        tabId: tabId
      });

      chrome.tabs.sendMessage(tabId, { changePermission: true });

    } catch (e) {
      chrome.runtime.sendMessage({
        closeTab: tabId,
      });
    }
  } catch (ex) {
    console.log("send noPermission message");
    chrome.tabs.sendMessage(tabId, { noPermission: true, ex: ex.message });
  }
};

var resumeAudioCapture = async function (tabId) {
  // Get a MediaStream for the active tab.
  const streamId = await chrome.tabCapture.getMediaStreamId({
    targetTabId: tabId
  });

  try {

    // Send the stream ID to the offscreen document to start recording.
    chrome.runtime.sendMessage({
      type: 'start-recording',
      target: 'offscreen',
      data: streamId,
      tabId: tabId
    });

  } catch (e) {
    chrome.runtime.sendMessage({
      closeTab: tabId,
    });
  }
};

chrome.runtime.onInstalled.addListener((details) => {
  const systemLang = chrome.i18n.getUILanguage();
  if (details.reason === chrome.runtime.OnInstalledReason.INSTALL) {
    // 只在首次安装时显示教程页面
    const systemLang = chrome.i18n.getUILanguage();
    if (systemLang == 'zh-CN' || systemLang == 'zh-TW') {
      chrome.tabs.create({ url: chrome.runtime.getURL("guide_zh.html") });
    } else {
      chrome.tabs.create({ url: chrome.runtime.getURL("guide_en.html") });
    }
  }

  let uninstallUrl = "https://account-api.ilivedata.com/feedback/chrome_uninstall_en.html";
  if (systemLang == 'zh-CN' || systemLang == 'zh-TW') {
    uninstallUrl = "https://account-api.ilivedata.com/feedback/chrome_uninstall_zh.html";
  }

  chrome.runtime.setUninstallURL(uninstallUrl, () => {
    if (chrome.runtime.lastError) {
      console.error("Failed to set uninstall URL:", chrome.runtime.lastError);
    } else {
      console.log("Uninstall URL set successfully.");
    }
  });
});

chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.status === "complete" && (/^https?:\/\//.test(tab.url) || /^http?:\/\//.test(tab.url))) {
    chrome.scripting.executeScript({
      target: { tabId: tabId },
      files: ["autoinsert.js"]
    });
    console.log("insert autoinsert.js");
  }
});

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === "open_popup") {
    console.log("open_popup");
    chrome.action.openPopup();
    sendResponse({ status: "popup opened" });
  }

  if (message.action === "jump_help") {
    const systemLang = chrome.i18n.getUILanguage();
    if (systemLang == 'zh-CN' || systemLang == 'zh-TW') {
      chrome.tabs.create({ url: chrome.runtime.getURL("guide_zh.html") });
    } else {
      chrome.tabs.create({ url: chrome.runtime.getURL("guide_en.html") });
    }
  }

  if (message.action === "user_feedback") {
    const systemLang = chrome.i18n.getUILanguage();
    if (systemLang == 'zh-CN' || systemLang == 'zh-TW') {
      // 浏览器跳转链接
      chrome.tabs.create({ url: "https://account-api.ilivedata.com/feedback/user_feedback_zh.html" });
    } else {
      chrome.tabs.create({ url: "https://account-api.ilivedata.com/feedback/user_feedback_en.html" });
    }
  }

  if (message.action === "user_login") {
    const systemLang = chrome.i18n.getUILanguage();
    if (systemLang == 'zh-CN' || systemLang == 'zh-TW') {
      // 浏览器跳转链接
      chrome.tabs.create({ url: "https://www.viitor.info/chrome/login?id=" + chrome.runtime.id });
    } else {
      chrome.tabs.create({ url: "https://www.viitor.info/chrome/login?id=" + chrome.runtime.id });
    }
  }

  if (message.action === "getCookie") {
    chrome.cookies.get({
      url: "https://ilivedata.com",
      name: "chrome_ex_token"
    }, function (cookie) {
      console.log(cookie);
      let token = cookie;
      chrome.cookies.get({
        url: "https://ilivedata.com",
        name: "chrome_ex_uid"
      }, function (uid) {
        if (uid) {
          token.uid = uid.value;
          sendResponse({ token: token });
        } else {
          token.uid = null;
          sendResponse({ token: null });
        }
      });
    });
  }

  if (message.action === "donwload_result") {
    const blob = new Blob([message.text], { type: "text/plain" });
    const reader = new FileReader();

    reader.onload = function () {
      chrome.downloads.download({
        url: reader.result,  
        filename: "viitor_translate_result.txt",
        saveAs: false
      });

      sendResponse({ status: "ok" });
    };

    reader.readAsDataURL(blob); 
    return true;

  }

  if (message.action === "setCookie") {
    chrome.cookies.set({
      url: "https://ilivedata.com",
      name: "chrome_ex_uid",
      value: message.uid,
      domain: "ilivedata.com",
      path: "/",
      expirationDate: Math.floor(Date.now() / 1000) + 315360000
    }, function (cookie) {
      if (chrome.runtime.lastError) {
        console.error("Error setting cookie:", chrome.runtime.lastError);
      } else {
        console.log("Permanent Cookie set successfully:", cookie);
      }
    });

    chrome.cookies.set({
      url: "https://ilivedata.com",
      name: "chrome_ex_version",
      value: message.version,
      domain: "ilivedata.com",
      path: "/",
      expirationDate: Math.floor(Date.now() / 1000) + 315360000
    }, function (cookie) {
      if (chrome.runtime.lastError) {
        console.error("Error setting cookie:", chrome.runtime.lastError);
      } else {
        console.log("Permanent Cookie set successfully:", cookie);
      }
    });

    const systemLang = chrome.i18n.getUILanguage();

    chrome.cookies.set({
      url: "https://ilivedata.com",
      name: "chrome_ex_lang",
      value: systemLang,
      domain: "ilivedata.com",
      path: "/",
      expirationDate: Math.floor(Date.now() / 1000) + 315360000
    }, function (cookie) {
      if (chrome.runtime.lastError) {
        console.error("Error setting cookie:", chrome.runtime.lastError);
      } else {
        console.log("Permanent Cookie set successfully:", cookie);
      }
    });
  }
});