let rtvtClient = null;
let rtvtStream = null;
let globalSeg = 0;

onmessage = function(e) {
    if (e.data == null || e.data == undefined || e.data == "") {
        return;
    }

    // console.log("-------- worker onmessage: ", e.data);

    let data = e.data;
    if (data.cmd == "start") {
        createRtvt(data.data);
    }
    else if (data.cmd == "stop") {
        globalSeg = 0;
        if (rtvtClient !== null) {
            rtvtClient.destory();
            rtvtClient = null;
        }
    }
    else if (data.cmd == "sendVoice") {
        if (rtvtClient !== null) { 
            // console.log("sendVoice");
            // const pcmData = (new Int16Array(request.pcmData)).buffer;
            rtvtClient.sendVoice(rtvtStream, globalSeg++, data.pcmData);
        }
    }
}

function uploadLog(event_id, log) {
    self.postMessage({cmd: "log", data: {
        "event_id" : event_id,
        "log" : log
    }});
}

function createRtvt(data) {
    rtvtClient = new RTVTClient({
        endpoint: data.endpoint,
        pid: data.pid,
        uid: data.globalConfig.uid,
    });

    rtvtClient.on("ReloginCompleted", function(ok, errorCode) {
        console.log("ReloginCompleted, ok: " + ok + " errorCode: " + errorCode);
    });

    rtvtClient.on("ErrorRecorder", function(error) {
        console.log(error);
        self.postMessage({cmd: "ErrorRecorder", errorCode: error.code, tabId: data.tabId});
    });

    rtvtClient.login(data.token, data.ts, async function(ok, errorCode) {
        console.log("login: ", ok, " errorCode: ", errorCode);
        //console.log(errorCode);
        
        let log = "rtvtClient login result: " + ok + " errorCode: " + errorCode;
        uploadLog("login", log);

        if (!ok) {
            console.log("login fail: " + errorCode);
            // TODO
            return;
        }

        needAlt = true;
        if (data.globalConfig.altLang == 'none')
            needAlt = false;

        var globalConfig = data.globalConfig;

        rtvtClient.createStream(globalConfig.uid, globalConfig.asrLang, globalConfig.altLang, true, true, needAlt, async function(stream, errorCode) {
            if (stream == null) {
                self.postMessage({cmd: "log", data: log});
                uploadLog("create_stream", "create stream fail: " + errorCode);
                // TODO
                return;
            }
            
            uploadLog("create_stream", "create stream id: " + stream._streamID.toString());

            rtvtStream = stream;

            rtvtClient.on("recognizedResult", function(data) {
                data.streamId = data.streamId.toString();
                data.taskId = data.taskId.toString();
                self.postMessage({cmd: "recognizedResult", data: data});
            });

            rtvtClient.on("recognizedTempResult", function(data) {
                self.postMessage({cmd: "recognizedTempResult", data: data});
            });

            rtvtClient.on("translatedResult", function(data) {
                data.streamId = data.streamId.toString();
                data.taskId = data.taskId.toString();
                self.postMessage({cmd: "translatedResult", data: data});
            });

            rtvtClient.on("translatedTempResult", function(data) {
                self.postMessage({cmd: "translatedTempResult", data: data});
            });
        });
    });
}